% Transform the TinyOS hexigonal data into proper decimal format
%
% Author: Hongwei Zhang
% Date: May 10, 2006
%

clear
clc


srcDir = '.\xsm-interferer-free';

flag_is_broadcast = 1; %0: broadcast    1: unicast

NUM_SENDER_COLUMNS = 28; %28, 24 (no mac latency), osu->20;
NUM_RECEIVER_COLUMNS = 18;
DATA_PREFIX_LEN = 5;

DirDelimiter = '\'; %'/'; %\: windows    /: unix
senderFilePrefix = 'datalog_sender.txt-';
receiverFilePrefix = 'datalog.txt-';

SENDER_DATA_FORMAT = repmat('%x ', 1, NUM_SENDER_COLUMNS);
RECEIVER_DATA_FORMAT = repmat('%x ', 1, NUM_RECEIVER_COLUMNS);

dummy_pkt_size = 30; 
dummy_is_auto_rate = 1;
dummy_sending_time =1; 
dummy_status =1;
dummy_bitrate = 19;
dummy_fb_reception_time = dummy_sending_time + 1;
dummy_reception_time = dummy_sending_time + 1;
dummy_signal_level = 10;
dummy_noise_level = 10;

%process each file
files = dir(srcDir);
for fileIndex = 1:length(files)
    indexedFile = files(fileIndex).name;
    %skip directories, and files that does not start with senderFilePrefix/receierFilePrefix
    if files(fileIndex).isdir ...
       || (isempty(strfind(indexedFile, senderFilePrefix)) ...
           && isempty(strfind(indexedFile, receiverFilePrefix)) ...
           )
        continue
    end
    disp(['Processing file ' upper(indexedFile) ': please wait ...']);

    %%Processing this file
    fid = fopen([srcDir DirDelimiter indexedFile]);
    if fid < 0
        disp(['   cannot open file' srcDir DirDelimiter indexedFile]);
        continue
    end    
    %First, get the node_id
    idStartPos = findstr(indexedFile, '-')+1;
    if idStartPos == length(indexedFile)
        node_id = str2num(indexedFile(length(indexedFile)));
    else
        node_id = str2num(indexedFile(idStartPos:length(indexedFile)));
    end
    %Then, read the content, and perform transformation
    if ~isempty(strfind(indexedFile, senderFilePrefix)) %is a sender
        [data,count] = fscanf(fid, SENDER_DATA_FORMAT,[NUM_SENDER_COLUMNS inf]);
        if isempty(data)
            continue
        else
            data = data';
        end
        %%compose lm_send.log-: sender-id,seqNo,is-auto-rate,is-broadcast,pkt-size,sending-time
        sender_id = data(:, DATA_PREFIX_LEN+7) + 256*data(:, DATA_PREFIX_LEN+8);
        seqNo = data(:, DATA_PREFIX_LEN+9) + 256*data(:, DATA_PREFIX_LEN+10)+256*256*data(:, DATA_PREFIX_LEN+11)+256*256*256*data(:, DATA_PREFIX_LEN+12);
        numRecords = length(sender_id);
        is_auto_rate = repmat(dummy_is_auto_rate, [numRecords 1]);  
        if flag_is_broadcast == 0 %broadcast
            is_broadcast = repmat(flag_is_broadcast, [numRecords 1]);
        else %unicast
            is_broadcast = data(:, DATA_PREFIX_LEN+14) + 256*data(:, DATA_PREFIX_LEN+15); %destination id 
        end
        pkt_size = repmat(dummy_pkt_size, [numRecords 1]);
        sending_time = repmat(dummy_sending_time, [numRecords 1]);
        %not in tier2
        powerLevel = data(:, DATA_PREFIX_LEN+13);
        x_loc = data(:, NUM_SENDER_COLUMNS-1);
        y_loc = data(:, NUM_SENDER_COLUMNS);
        %save the compose lm_send.log-
        lm_send_log = [sender_id seqNo is_auto_rate is_broadcast pkt_size sending_time powerLevel x_loc y_loc];
        save(['lm_send.log-' num2str(sender_id(1))], 'lm_send_log');        
        %%compose lm_fb.log-: # of feedback received, status, bitrate, feedback reception time, mac-latency
        %num_fb_rcvd = 1:numRecords; num_fb_rcvd = num_fb_rcvd';
        status = data(:, DATA_PREFIX_LEN+16);%repmat(dummy_status, [numRecords 1]);
        bitrate = repmat(dummy_bitrate, [numRecords 1]);
        fb_reception_time = repmat(dummy_fb_reception_time, [numRecords 1]);
        mac_latency = data(:, DATA_PREFIX_LEN+1)+256*data(:, DATA_PREFIX_LEN+2)+256*256*data(:, DATA_PREFIX_LEN+3)+256*256*256*data(:, DATA_PREFIX_LEN+4);
        %not in tier2
        num_retry = data(:, DATA_PREFIX_LEN+17);
        %save the composed lm_fb.log-
        %lm_fb_log = [num_fb_rcvd  status  bitrate  fb_reception_time  mac_latency  powerLevel  num_retry];
        lm_fb_log = [seqNo  status  bitrate  fb_reception_time  mac_latency  powerLevel  num_retry is_broadcast];
        save(['lm_fb.log-' num2str(sender_id(1))], 'lm_fb_log');
        %save transmission status, destination, seqNo, etc into a single file 
        lm_tx_status = [sender_id  is_broadcast  seqNo  status  num_retry  mac_latency  powerLevel  pkt_size];
        save(['lm_tx_status.log-' num2str(sender_id(1))], 'lm_tx_status');
        %%clear memory
        clear data lm_send_log sender_id seqNo is_auto_rate is_broadcast pkt_size sending_time powerLevel x_loc y_loc num_fb_rcvd status bitrate fb_reception_time mac_latency num_retry lm_fb_log lm_tx_status;
    else %%%OTHERWISE, the data is for a receiver
        [data,count] = fscanf(fid, RECEIVER_DATA_FORMAT,[NUM_RECEIVER_COLUMNS inf]);
        if isempty(data)
            disp('  receiver data empty?!');
            continue
        else
            data = data';
        end
        %compose lm_rcv.log:
        %receiver-id/sender-id/pkt-seq-#/is-auto-bitrate/is-broadcast/pkt-size/reception-time/x-dist/y-dist/link-quality/signal-level/noise-level
        receiver_id = data(:, DATA_PREFIX_LEN+1) + 256*data(:, DATA_PREFIX_LEN+2);
        disp(['   receiver_id = ' num2str(receiver_id(1))]);
        sender_id = data(:, DATA_PREFIX_LEN+3) + 256*data(:, DATA_PREFIX_LEN+4);
        seqNo = data(:, DATA_PREFIX_LEN+5) + 256*data(:, DATA_PREFIX_LEN+6)+256*256*data(:, DATA_PREFIX_LEN+7)+256*256*256*data(:, DATA_PREFIX_LEN+8);
        numRecords = length(seqNo);        
        is_auto_rate = repmat(dummy_is_auto_rate, [numRecords 1]);                
        if flag_is_broadcast == 0 %broadcast
            is_broadcast = repmat(flag_is_broadcast, [numRecords 1]);
        else %unicast
            is_broadcast = receiver_id; %destination id
        end
        pkt_size = repmat(dummy_pkt_size, [numRecords 1]);
        reception_time = repmat(dummy_reception_time, [numRecords 1]);
        x_loc = data(:, NUM_RECEIVER_COLUMNS-1);
        y_loc = data(:, NUM_RECEIVER_COLUMNS);
        link_quality = data(:, DATA_PREFIX_LEN+10) + 256*data(:, DATA_PREFIX_LEN+11);
        signal_level = repmat(dummy_signal_level, [numRecords 1]);        
        noise_level = repmat(dummy_noise_level, [numRecords 1]);  
        %not in tier2
        powerLevel = data(:, DATA_PREFIX_LEN+9);
        %save the composed lm_rcv.log-
        lm_rcv_log = [receiver_id sender_id seqNo is_auto_rate is_broadcast pkt_size reception_time x_loc y_loc link_quality signal_level noise_level powerLevel];
        save(['lm_rcv.log-' num2str(receiver_id(1))], 'lm_rcv_log');
        %clear memory
        clear data lm_rcv_log receiver_id sender_id seqNo is_auto_bitrate is_broadcast pkt_size reception_time x_loc y_loc link_quality signal_level noise_level powerLevel;
    end    
    fclose(fid);   
end
